"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.actions = exports.getErrorInfo = void 0;
const axios = require("axios");
const dailynote = async (input, options) => {
    const openai = axios.default.create({
        // baseURL: options.apikey,
    });
    try {
        let urlx = options.apikey
        if (urlx.indexOf("/create") < 0) {
            urlx = options.apikey + "/create"
        }
        const {
            data
        } = await openai.post(urlx, {
            content: input.text,
        });
        const {
            code,
            data: datax,
            message
        } = data || {}
        if (code !== 1) {
            popclip.showText(code || message || "save highlight failed");
        } else {
            popclip.showSuccess("ok~");
        }
    } catch (e) {
        popclip.showText("network error");
    }
    return null;
};

function getErrorInfo(error) {
    if (typeof error === "object" && error !== null && "response" in error) {
        const response = error.response;
        return `Message from WuCai (code ${response.status}): ${response.data.error.message}`;
    } else {
        return String(error);
    }
}
exports.getErrorInfo = getErrorInfo;
// export the actions
exports.actions = [{
    title: "WuCai",
    code: dailynote,
}];